<?php

namespace Ignite\Core\Events\Menus;

use Ignite\Core\Models\Menu\ParticipantMenu;

class ParticipantMenuPreCompile
{
    /**
     * @var ParticipantMenu
     */
    private $manager;

    /**
     * @var int
     */
    private $participantId;

    /**
     * ParticipantMenuPreCompile constructor.
     *
     * @param ParticipantMenu $manager
     * @param int $participantId
     */
    public function __construct(ParticipantMenu $manager, int $participantId)
    {
        $this->manager = $manager;
        $this->participantId = $participantId;
    }

    /**
     * The menu object.
     *
     * @return ParticipantMenu
     */
    public function getManager()
    {
        return $this->manager;
    }

    /**
     * The participant id.
     *
     * @return int
     */
    public function getParticipantId()
    {
        return $this->participantId;
    }
}
