<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(\Ignite\Core\Entities\Participant::class, function (\Faker\Generator $faker) {
    $user = factory(Ignite\Core\Entities\User::class, 1)->create()->first();

    return [
        "user_id" => $user->user_id,
        "title" => null,
        "email" => $user->email,
        "first" => $user->first,
        "last" => $user->last,
        "type" => "Account Executive",
        "phone1" => $faker->phoneNumber,
        "address_1" => $faker->streetAddress,
        "address_2" => null,
        "city" => $faker->city,
        "state" => $faker->stateAbbr,
        "postal" => $faker->postcode,
        "country" => 'US',
        "status" => 1,
        "archived" => 0,
        "internal" => 1,
        "internal_notes" => null,
        "approved_at" => $faker->date('Y-m-d H:i:s'),
        "created_at" => $faker->date('Y-m-d H:i:s'),
        "updated_at" => $faker->date('Y-m-d H:i:s'),
    ];
});
