<?php

namespace Ignite\Core\Entities;

class GroupPermission extends Base
{
    /**
     * The custom table name.
     * @var string
     */
    protected $table = 'core_group_permission';

    /**
     * Eloquent event listeners.
     */
    public static function boot()
    {
        parent::boot();

        static::saved(function () {
            app('authorization')->forgetPermissions()->registerPermissions();
        });
    }

    /**
     * Perform any actions required after the model boots.
     *
     * @return void
     */
    protected static function booted()
    {
        static::addGlobalScope(app(Scopes\GroupPermissionScope::class));
    }

    /**
     * The relationship to the group the permission belongs.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function group()
    {
        return $this->belongsTo(Group::class, 'id', 'group_id');
    }

    /**
     * The relationship to the permissions saved for this permission group.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function permissions()
    {
        return $this->hasMany(Permission::class, 'id', 'permission_id');
    }
}
