<?php

namespace Ignite\Core\Entities;

use DateTimeInterface;
use Illuminate\Database\Eloquent\Model;

abstract class Base extends Model
{
    /**
     * The attributes which cannot be mass assigned.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * Prepare a date for array / JSON serialization.
     *
     * @param  \DateTimeInterface  $date
     * @return string
     */
    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
