<?php

namespace Ignite\Core\Models\Dashboard;

use Ignite\Core\Contracts\Dashboard\Gauge as GaugeInterface;

abstract class Gauge extends Chart implements GaugeInterface
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        parent::__construct(array_merge([
            'element' => $this->getElement(),
            'size' => 'col-xs-12 col-sm-6 col-md-4 col-lg-3',
            'colors' => $this->getColors(),
            'slices' => $this->getColorSlices(),
        ], $attributes ?? []));
    }

    /**
     * The color of the stat.
     *
     * @return array
     */
    public function getColors()
    {
        if (empty($this->offsetGet('colors'))) {
            $this->offsetSet('colors', [
                '#c82d2d',
                '#fdbc18',
                '#53a629',
            ]);
        }

        return $this->attributes['colors'];
    }

    /**
     * The color of the stat.
     *
     * @return array
     */
    public function getColorSlices()
    {
        $colorSlices = $this->getSlices();

        /* Default color scheme
         *
         * greenFrom: 0, greenTo: 30,
         * yellowFrom: 30, yellowTo: 70,
         * redFrom: 70, redTo: 100,
         */

        $colors = vsprintf('greenFrom: %s, greenTo: %s,', $colorSlices[0]);
        $colors .= vsprintf('yellowFrom: %s, yellowTo: %s,', $colorSlices[1]);
        $colors .= vsprintf('redFrom: %s, redTo: %s', $colorSlices[2]);

        $this->attributes['slices'] = $colors;

        return $this->attributes['slices'];
    }

    /**
     * The HTML class of an icon.
     *
     * @return string
     */
    public function getIcon()
    {
        return $this->get('icon');
    }

    /**
     * Calculate and return slice sizes.
     * Default should be [30, 40, 30] which give a return array of [[0, 30], [30, 70], [70, 100]]
     *
     */
    public function getSlices()
    {
       $sliceSizes = $this->get('slices', [[0, 30], [30, 70], [70, 100]]);
        if (!is_array($sliceSizes)) {
            return [[0, 30], [30, 70], [70, 100]];
        }

        $slices = [];
        if (isset($sliceSizes[0]) && is_array($sliceSizes[0])) {
            foreach ($sliceSizes as $slice) {
                $slices[] = $slice;
            }

            return $slices;
        }

        $count = 0;
        if (isset($sliceSizes[0]) && !is_array($sliceSizes[0])) {
            foreach ($sliceSizes as $slice) {
                $start = $count;
                $end = $start + $slice;
                $slices[] = [$start, $end];

                $count = $end;
            }

            return $slices;
        }

        return false;
    }

    /**
     * The simple name of the type of stat.
     *
     * @return string
     */
    public function getType()
    {
        return 'gauge';
    }
}
