<?php

namespace Ignite\Core\Services\Files;

use League\Flysystem\Util as FlysystemUtil;

class MimeTypes
{
    /**
     * Get a mime type from a given filename.
     * We could build this more like Symfony's and build guesser classes: \Symfony\Component\Mime\MimeTypes::registerGuesser
     * (Symfony's only works on files on the filesystem)
     *
     * @param string $filename
     * @return array|false|string|string[]|void|null
     */
    public static function fromFilename(string $filename)
    {
        // This function was turned into a static method between 6.5 and 7.4
        if (function_exists('\GuzzleHttp\Psr7\mimetype_from_filename')) {
            return mb_strtolower(\GuzzleHttp\Psr7\mimetype_from_filename($filename));
        }

        // This is the new static method Guzzle introduced to replace mimetype_from_filename().
        if (method_exists('\GuzzleHttp\Psr7\MimeType', 'fromFilename')) {
            return \GuzzleHttp\Psr7\MimeType::fromFilename($filename);
        }

        // And, fall back to flysystem, because why not? It's in the codebase already. :)
        return FlysystemUtil::guessMimeType($filename, '');
    }
}
