<?php

namespace Ignite\Core\Http\ViewComposers;

use Ignite\Core\Contracts\Repositories\GroupRepository;
use Illuminate\View\View;

class GroupsDropdownComposer
{
    /**
     * @var GroupRepository
     */
    private $groupRepository;

    /**
     * GroupsDropdownComposer constructor.
     *
     * @param GroupRepository $groupRepository
     */
    public function __construct(GroupRepository $groupRepository)
    {
        $this->groupRepository = $groupRepository;
    }

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $groups = $this->groupRepository->query()->orderBy('level')->get();
        $view->with('groups', $groups);
    }
}
