<?php

namespace Ignite\Core\Models\Dashboard;

use Ignite\Core\Contracts\Dashboard\Line as LineInterface;

abstract class Line extends Chart implements LineInterface
{
    /**
     * Line Chart constructor.
     *
     * @param array $attributes
     */
    public function __construct($attributes = [])
    {
        parent::__construct(array_merge([
            'strokeWidth' => [],
            'strokeCurve' => 'smooth',
            'strokeDash' => [],
            'height' => 320
        ], $attributes));
    }


    /**
     * The key of the X-Axis in the data.
     *
     * @return string
     */
    public function getXKey()
    {
        return $this->get('xkey');
    }

    /**
     * The keys of the Y-Axis in the data.
     *
     * @return string
     */
    public function getYKeys()
    {
        return $this->get('ykeys');
    }

    /**
     * The color of the stat.
     *
     * @return string
     */
    public function getColors()
    {
        return $this->get('colors');
    }

    /**
     * The HTML class of an icon.
     *
     * @return string
     */
    public function getIcon()
    {
        return $this->get('icon');
    }

    /**
     * Get the Y axis labels.
     *
     * @return array
     */
    public function getLabels()
    {
        return $this->get('labels');
    }

    /**
     * The simple name of the type of stat.
     *
     * @return string
     */
    public function getType()
    {
        return 'line';
    }
}
