<?php

namespace Ignite\Core\Tests\Unit;

use Ignite\Core\Program;
use Ignite\Core\Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;

class ProgramTest extends TestCase
{
    use RefreshDatabase;

    /**
     * @test
     * @group Program
     */
    public function it_will_default_to_redemption_when_it_cannot_get_the_configured_type()
    {
        $program = new Program($this->app);

        $this->assertEquals(Program::TYPE_REDEMPTION, $program->getType());
    }

    /**
     * @test
     * @group Program
     */
    public function it_can_get_the_configured_type()
    {
        $this->app['config']->set('core.program_type', 'foo');

        $program = new Program($this->app);

        $this->assertEquals('foo', $program->getType());
    }

    /**
     * @test
     * @group Program
     */
    public function it_can_determine_whether_the_program_is_a_payout_program()
    {
        $this->app['config']->set('core.program_type', Program::TYPE_PAYOUT);

        $program = new Program($this->app);

        $this->assertTrue($program->isPayout());
    }

    /**
     * @test
     * @group Program
     */
    public function it_can_determine_whether_the_program_is_a_redemption_program()
    {
        $this->app['config']->set('core.program_type', Program::TYPE_REDEMPTION);

        $program = new Program($this->app);

        $this->assertTrue($program->isRedemption());
    }
}
