<?php

namespace Ignite\Core\Entities;

use Carbon\Carbon;

/**
 * Class TransactionResource.
 *
 * @property int $id
 * @property string $identfier
 * @property int $related_id
 * @property string $related_type
 * @property string $related_name
 * @property string $type
 * @property string $description
 * @property string $notes
 * @property float $value
 * @property Carbon $tax_date
 * @property Carbon $transaction_date
 * @property string $hash
 * @property Carbon $created_at
 * @property Carbon $updated_at
 */
class TransactionResource extends Transaction
{
    /**
     * The name of the table.
     *
     * @var string
     */
    protected $table = 'core_transaction_resource';

    /**
     * The guarded attributes.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * Perform any actions required after the model boots.
     *
     * @return void
     */
    protected static function booted()
    {
        static::addGlobalScope(app(Scopes\TransactionResourceScope::class));
    }
}
