<form id="adjustment" class="form-horizontal" method="post" action="{{ route('admin.participant.transactions.store', $participant->getId()) }}">
    {{ csrf_field() }}
    <input type="hidden" name="id" value="{{ $transaction['id'] ?? '' }}" />
    <input type="hidden" name="user_id" value="{{ $transaction['user_id'] ?? $participant->getId() }}" />
    <input type="hidden" name="related_id" value="{{ $transaction['related_id'] ?? 0 }}" />
    <div class="form-group">
        <label for="transaction_date" class="col-sm-4 control-label required">Transaction Date:</label>
        <div class="col-sm-8">
            <input type="text" class="form-control datepicker" id="transaction_date" name="transaction_date" value="{{ $transaction['transaction_date'] ?? date('m/d/Y') }}" />
        </div>
    </div>
    <div class="form-group">
        <label for="tax_date" class="col-sm-4 control-label required">Tax Date:</label>
        <div class="col-sm-8">
            <input type="text" class="form-control datepicker" id="tax_date" name="tax_date" value="{{ $transaction['tax_date'] ?? date('m/d/Y') }}" />
        </div>
    </div>
    <div class="form-group">
        <label for="type" class="col-sm-4 control-label required">Adjustment Type:</label>
        <div class="col-sm-8">
            <select style="width: 100%" class="form-control select2" name="type" id="type" required>
                <option value="">--- select ---</option>
                @foreach($transactionTypes as $value => $text)
                    <option value="{{ $value }}" label="{{ $text }}" @if( $value == ( $transaction['type'] ?? '' )  )selected="selected"@endif>{{ $text }}</option>
                @endforeach
            </select>
            <div class="help-block text-danger">
                <div class="help-text help-cancelled hide">Please make sure you add a minus sign before the value below.</div>
                <div class="help-text help-earned hide">Earned points will appear on the participant's Tax Report.</div>
                <div class="help-text help-redeemed hide">Please make sure you add a minus sign before the value below.</div>
                <div class="help-text help-manual-receive hide">Manual Received points will appear on the participant's Tax Report.</div>
                <div class="help-text help-manual-redeem hide">Please make sure you add a minus sign before the value below.</div>
                <div class="help-text help-expired hide">Please make sure you add a minus sign before the value below.</div>
                <div class="help-text help-reset hide">Please make sure you add a minus sign before the value below.</div>
                <div class="help-text help-return hide">Please make sure you add a minus sign before the value below.</div>
            </div>
            @push('js')
            <script>
                jQuery(document).ready(function ($) {
                    $('#type').on('change', function (e) {
                        var $el = $(this);
                        var $block = $el.siblings('.help-block');
                        var $help = $block.find('.help-' + $el.val().toLowerCase().replace(' ', '-'));
                        $block.find('.help-text').addClass('hide');
                        $help.removeClass('hide');
                        console.log('.help-' + $el.val().toLowerCase().replace(' ', '-'), $help);
                    })
                });
            </script>
            @endpush
        </div>
    </div>
    <div class="form-group">
        <label for="value" class="col-sm-4 control-label required">Value:</label>
        <div class="col-sm-8">
            <input type="text" class="form-control" id="value" name="value" value="{{ $transaction['value'] ?? '' }}" />
            <div class="help-block text-danger">When taking points, you must include the minus sign, e.g. -100.</div>
        </div>
    </div>
    <div class="form-group">
        <label for="description" class="col-sm-4 control-label required">Description:</label>
        <div class="col-sm-8">
            <input type="text" class="form-control" id="description" name="description" rows="3" cols="75" value="{{ $transaction['description'] ?? '' }}">
        </div>
    </div>
    <div class="form-group">
        <label for="notes" class="col-sm-4 control-label">Notes:</label>
        <div class="col-sm-8">
            <textarea placeholder="Please add some additional context if you have the time..." class="form-control" id="notes" name="notes" rows="3" cols="75">{{ $transaction['notes'] ?? '' }}</textarea>
        </div>
    </div>
    <div class="form-group">
        <div class="col-sm-offset-4 col-sm-4">
            <a class="btn btn-default" href="{{ isset($cancelURI) ? url($cancelURI) : '#' }}" data-dismiss="modal">Cancel</a>
        </div>
        <div class="col-sm-4">
            <button type="submit" class="btn btn-primary pull-right" id="adjustSubmit">Submit</button>
        </div>
    </div>
</form>
