@extends('Core::layouts.participant')

@section('page_heading', $pageTitle = 'Internal Users')
@section('page_breadcrumb', $pageTitle)

@section('tab_menu')
    @include('Core::partials.tabs', [
        'current' => request()->segment(4),
        'statuses' => $statuses,
        'route' => 'admin.participant.internal'
    ])
@endsection

@section('tab_content')
    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            $dataTable.customButtons({
                buttons: [{
                    text: '<span class="fa fa-plus text-success"></span> <span class="text-success">Create</span>',
                    action: function (e) {
                        e.preventDefault();
                        window.location.href = '{{ route('admin.participant.create', ['type' => 'internal']) }}';
                    }
                }]
            });
        });
    </script>
@endsection
