@extends('Core::layouts.report')

@section('page_heading',  $report->getName() . ' Report')
@section('page_breadcrumb', $report->getName() . ' Report')

@section('page_content')
    <div class="row">
        <div class="col-sm-12">
            <div class="box box-primary">
                <div class="box-body">
                    @if (! empty($filters))
                    <div class="report-filter row form-inline">
                        @foreach ($filters as $class => $filter)
                            @if (get_class($report->getReportClassInstance()) === $class)
                            @include($filter['view'], compact('report'))
                            @endif
                        @endforeach
                    </div>
                    @endif
                    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('css')
    @parent
    <style>
        .report-filter {
            margin-bottom: 10px;
        }
    </style>
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
@endsection
