<?php

namespace Ignite\Core\Models\Grid;

use Illuminate\Database\DatabaseManager;
use Yajra\DataTables\DataTables;

class WaitingTransactionsTable extends QueryTable
{
    /**
     * The excluded column keys.
     *
     * @var array
     */
    protected $excludedKeys = [];

    /**
     * The column keys that should be always visible.
     *
     * @var array
     */
    protected $alwaysVisible = [
        'identifier', 'value'
    ];

    /**
     * @var WaitingTransactionsFormatter
     */
    protected $formatter;

    /**
     * ParticipantTable constructor.
     *
     * @param DataTables                   $datatables
     * @param DatabaseManager              $databaseManager
     * @param WaitingTransactionsFormatter $formatter
     * @param array                        $params
     */
    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        WaitingTransactionsFormatter $formatter,
        array $params = []
    ) {
        parent::__construct($datatables, $databaseManager, $params);

        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'action' => [
                'name' => 'action',
                'title' => 'Actions',
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'visible' => true,
                'width' => '140px',
                'class' => 'actions'
            ],
            'id' => [
                'title' => 'ID',
                'name' => 'id',
                'orderable' => true,
                'exportable' => true,
            ],
            'identifier' => [
                'title' => 'Identifier',
                'name' => 'identifier',
                'orderable' => true,
                'exportable' => true,
            ],
            'type' => [
                'title' => 'Type',
                'name' => 'type',
                'orderable' => true,
                'exportable' => true,
            ],
            'description' => [
                'title' => 'Description',
                'name' => 'description',
                'orderable' => true,
                'exportable' => true,
            ],
            'tax_date' => [
                'title' => 'Tax Date',
                'name' => 'tax_date',
                'orderable' => true,
                'exportable' => true,
            ],
            'transaction_date' => [
                'title' => 'Transaction Date',
                'name' => 'transaction_date',
                'orderable' => true,
                'exportable' => true,
            ],
            'value' => [
                'title' => 'Value',
                'name' => 'value',
                'orderable' => true,
                'exportable' => true,
            ],
        ];
    }

    /**
     * The waiting transactions query.
     *
     * @return \Illuminate\Database\Query\Builder
     */
    public function query()
    {
        $columns = collect($this->getColumns())
            ->keyBy('name')
            ->except('action')
            ->keys()
            ->toArray();

        return $this->getConnection()
            ->table('core_transaction_resource')
            ->select($columns)
            ->distinct();
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'action' => [$this->formatter, 'actions'],
            'value' => [$this->formatter, 'balance']
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        return parent::getBuilderParameters([
            'order' => [
                [6, 'desc'] // Transaction Date
            ]
        ]);
    }
}
