<?php

namespace Ignite\Core\Models\Dashboard\Charts;

use Ignite\Core\Contracts\Dashboard\WithInlineSeries;
use Ignite\Core\Contracts\Dashboard\WithPercentageChange;
use Ignite\Core\Models\Dashboard\Concerns\DeterminesPercentageChange;
use Ignite\Core\Services\Google\Analytics\Client;

class BounceRateStat extends BaseGoogleAnalyticsMetric implements WithInlineSeries, WithPercentageChange
{
    use DeterminesPercentageChange;

    /**
     * Create a new stat instance.
     *
     * @param array|object $attributes
     * @param Client $analytics
     */
    public function __construct(Client $analytics, $attributes = [])
    {
        $attributes = array_merge([
            'label' => 'Bounce Rate',
        ], $attributes);

        parent::__construct($analytics, $attributes);
    }

    /**
     * @inheritDoc
     */
    public function setSeries(array $data)
    {
        $this->offsetSet('series', array_map(function ($value) {
            return (empty($value)) ? 0 : $this->decorate($value);
        }, $data));

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setPercentageChange($current, $previous)
    {
        $this->offsetSet('current', $this->decorate($current));
        $this->offsetSet('previous', $this->decorate($previous));
        $this->offsetSet('direction', $this->determineChangeType($current, $previous));
        $this->offsetSet('percentage', $this->determinePercentageChange($current, $previous));
    }

    /**
     * @inheritDoc
     */
    public function getElement()
    {
        return $this->get('key', 'bounce-rate-stat');
    }

    /**
     * @inheritDoc
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-6 col-sm-3');
    }

    /**
     * @inheritDoc
     */
    public function getData()
    {
        return $this->prepareData('bounceRate');
    }


    /**
     * @inheritDoc
     */
    protected function decorate($value)
    {
        return number_format($value, 2) . '%';
    }
}
