<?php

namespace Ignite\Core\Database\Seeders;

use Ignite\Core\Entities\Group;
use Ignite\Core\Entities\Permission;

class GroupPermissionTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath('core_group_permission.json')
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();
        $permissions = Permission::whereIn('key', $sources->pluck('permission_key')->toArray())->get()->keyBy('key');

        if ($permissions->isEmpty()) {
            echo 'No permissions were seeded.';
            return;
        }

        foreach ($sources as $source) {
            try {
                /** @var Group $group */
                $groups = Group::whereIn('key', explode('|', $source['group_name']))->get();
                $permission = $permissions[$source['permission_key']];
                foreach ($groups as $group) {
                    $hasPermission = $group->hasPermission($permission);
                    if (! $hasPermission) {
                        // dump("Giving {$permission->key} to {$group->name}");
                        $group->givePermissionTo($permission);
                    } elseif ($hasPermission) {
                        // dump("Already has permission {$permission->key} for {$group->name}");
                    }
                }
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
