<?php

namespace Ignite\Core\Http\Forms;

use Ignite\Core\Models\Form\Form;

class PasswordForm extends Form
{
    /**
     * Build the enrollment form.
     *
     * @return mixed|void
     * @throws \Exception
     */
    public function buildForm()
    {
        $this->setFormOptions([
            'id' => 'password-form',
            'class' => 'form-horizontal',
            'novalidate'
        ]);

        $this->add('password', 'password', [
            'label' => 'New Password',
            'rules' => [
                'required',
                'confirmed'
            ],
            'label_attr' => ['class' => 'control-label col-sm-3'],
            'form_horizontal' => true
        ]);

        $this->add('password_confirmation', 'password', [
            'label' => 'Confirm Password',
            'rules' => [
                'required'
            ],
            'label_attr' => ['class' => 'control-label col-sm-3'],
            'form_horizontal' => true
        ]);

        $this->add('old_password', 'password', [
            'label' => 'Old Password',
            'rules' => [
                'required'
            ],
            'label_attr' => ['class' => 'control-label col-sm-3'],
            'form_horizontal' => true
        ]);

        $this->add('change', 'submit', [
            'label' => 'Change',
            'attr' => [
                'class' => 'btn btn-primary pl-4 pr-4'
            ],
            'wrapper' => [
                'class' => 'form-button text-right'
            ]
        ]);
    }
}
