@extends('Core::layouts.main')

@section('meta_title', 'Dashboard')

@section('heading')
    <div class="clearfix">
        <h1 class="pull-left" style="font-size: 24px; margin-top: 0; position: relative; top: 3px;">Dashboard</h1>
        @unless (empty($dashboards))
            <div class="input-group pull-left" style="max-width: 400px; margin-left: 25px;">
                <form name="views" method="GET" action="{{ route('admin.dashboard.index') }}">
                    <select title="Choose Dashboard View" onchange="forms.views.submit()" name="dashboard" id="dashboard" class="select2 pull-left" style="min-width: 200px;">
                        @foreach ($dashboards as $value)
                            <option {{ $value === $dashboard ? 'selected' : '' }} value="{{ $value }}">{{ $value }} Dashboard</option>
                        @endforeach
                    </select>
                </form>
            </div>
        @endunless
        @include('Core::admin.dashboard.date-range-picker')
    </div>
@endsection

@section('page_content')

	<div class="row">
        @forelse ($charts as $chart)
            @component("Core::admin.dashboard.components.{$chart->getType()}", $chart->toArray())@endcomponent
        @empty
            <div class="col-xs-12"><p>No charts available.</p></div>
        @endforelse
    </div>
@stop

@section('js')
@parent
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery.matchHeight/0.7.2/jquery.matchHeight-min.js"></script>
<script type="text/javascript">
    jQuery(function($) {
        var types = ['.chart-stat', '.chart-correlated-stat', '.chart-donut', '.chart-line', '.chart-table'];
        for (var i = 0; i <= types.length; i++) {
            var type = types[i];
            var elements = $(type);
            var tallest = $(type).first();
            var smallest = $(type).first();
            for (var j = 0; j <= elements.length; j++) {
                var next = $(elements[j]);
                if (tallest.height() <= next.height()) {
                    tallest = next;
                } else {
                    smallest = next;
                }
            }

            $(type).matchHeight({
                byRow: true,
                property: 'min-height',
                target: tallest,
                remove: true
            });
        }
    });
</script>
@endsection
