(function(jQuery, window, document, undefined) {
    'use strict';

    jQuery(document).ready(function($) {

        $(document).on('click', '#clear-local-storage', function () {
            if (window.hasOwnProperty('localStorage')) {
                window.localStorage.clear();
                window.location.reload(true);
            }
        });

        var initAffixedArea = function(element, options) {
            var affixed = $(element || '.form-affix-actions');
            if (!affixed.length) return;
            var settings = $.extend({
                container: '.form-affix-container',
                sibling: '.form-affix-body'
            }, options);
            affixed.on('affix.bs.affix', function() {
                affixed.css({ width: $(settings.container).outerWidth() - $(settings.sibling).outerWidth() });
            }).on('affix-top.bs.affix', function() {
                affixed.css({ width: '' });
            }).affix({
                offset: { top: affixed.offset().top }
            });

            return affixed;
        };

        var affixed = initAffixedArea();
        (typeof affixed !== 'undefined') && $(window).on('resize', function() {
            if ($(window).width() >= 992) {
                initAffixedArea();
                if (affixed.hasClass('affix')) affixed.trigger('affix.bs.affix');
                if (affixed.hasClass('affix-top')) affixed.trigger('affix-top.bs.affix');
            } else {
                affixed.css({ width: '' });
                affixed.removeClass("affix affix-top affix-bottom")
                affixed.removeData("bs.affix");
                $(window).off('.affix');
            }
        });

        var dismissDevAlert = function($alert) {
            $('body').removeClass('env-local').removeClass('env-staging');
            $alert.remove();
        };

        var $alert = $('#dev-alert');
        var $alertDismiss = $('#dev-alert-dismiss');
        if (window.Ignite.Core.getCookie('dev_alert_dismissed') === '1') {
            dismissDevAlert($alert);
        }
        if ($alertDismiss.length) {
            $alertDismiss.on('click', function(evt) {
                evt.preventDefault();
                dismissDevAlert($alert);
                window.Ignite.Core.setCookie('dev_alert_dismissed', 1, 1);
            });
        }
    });

})(jQuery, window, document);