<?php

namespace Ignite\Core\Models\Options;

use Ignite\Core\Contracts\Source;
use Ignite\Core\Repositories\ParticipantRepository;

class ParticipantTypes implements Source
{
    /** @var ParticipantRepository */
    protected $participantRepository;

    /**
     * ParticipantTypes constructor.
     *
     * @param ParticipantRepository $participantRepository
     */
    public function __construct(ParticipantRepository $participantRepository)
    {
        $this->participantRepository = $participantRepository;
    }

    /**
     * The source as a key-value pair array with the value as the key and the label as the value.
     *
     * @return array
     */
    public function toDropdown()
    {
        return $this->participantRepository->getTypes();
    }
}
