<?php

namespace Ignite\Core\Database\Seeders;

use Ignite\Core\Contracts\Repositories\PageRepository;

class PageTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $pageRepository = app(PageRepository::class);
        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath('core_page.json')
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run()->sortBy('position');

        foreach ($sources as $source) {
            try {
                $source['published_at'] = now();
                $pageRepository->create($source);
            } catch (\Exception $e) {
                //echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
