<?php

namespace Ignite\Core\Http\ViewComposers;

use Illuminate\Contracts\View\View;
use Ignite\Core\Contracts\Repositories\ImportRepository;

class RecentImports
{
    /**
     * @var ImportRepository
     */
    private $importRepository;

    /**
     * RecentImports constructor.
     *
     * @param ImportRepository $importRepository
     */
    public function __construct(ImportRepository $importRepository)
    {
        $this->importRepository = $importRepository;
    }

    /**
     * Bind the imports to the view.
     *
     * @param View $view
     */
    public function compose(View $view)
    {
        $view->with('imports', $this->importRepository->paginate($this->importsPerPage()));
    }

    /**
     * The number of imports to display per page.
     *
     * @return int
     */
    private function importsPerPage()
    {
        return (int) config('core.import.ui.recent.per_page', 10);
    }
}
