@extends('Core::layouts.cms')

@php
$templateCode = str_replace('/', '.', ltrim($block->code, '/'))
@endphp

@section('page_heading', 'Editing Block: ' . $block->name)
@section('page_breadcrumb', 'Editing Block: ' . $block->name)

@section('page_content')
    @include('Core::admin.cms.partials.form.block', [
        'url' => route('admin.blocks.update', ['id' => $block->getKey()]),
        'page' => $block,
        'method' => 'PUT'
    ])

    @include('Core::admin.cms.partials.form.media-uploads', compact('templateCode'))
    @include('Core::admin.cms.partials.form.media-modal', compact('templateCode'))
@endsection

@section('js')
    @parent
    <script type="text/javascript">
        window.Laravel = window.Laravel || {};
        window.Laravel.csrfToken = "{{ csrf_token() }}";
    </script>
    <script src="/vendor/ignite/js/cms/media-upload.js"></script>
    <script src="/vendor/ignite/js/cms/media-manager.js"></script>
    <script type="text/javascript">
        window.Blocks = {};
        window.Blocks.code = $('#form-content-code').val() || '{{ $templateCode }}';
        window.Blocks.indexUrl = "{{ route('admin.blocks.index') }}";
        window.Blocks.createUrl = "{{ route('admin.blocks.create') }}";
        window.Blocks.editUrl = "{{ route('admin.blocks.edit', ['id' => $block->getKey()]) }}";

        jQuery(document).ready(function($) {
            $('#page-editor').igniteEditor({
                csrfToken: window.Laravel.csrfToken,
                templateCode: window.Blocks.code
            });
        });
    </script>
@endsection
