<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePageTable extends Migration
{
    /** @var string */
    protected $pageTable = 'core_page';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->pageTable, function (Blueprint $table) {
            $table->increments('id');
            $table->string('label', 255);
            $table->string('code', 255)->nullable()->unique();
            $table->string('locale', 5)->nullable()->default('en_US');
            $table->text('content');
            $table->string('meta_title', 255)->nullable();
            $table->string('meta_description', 255)->nullable();
            $table->string('meta_keywords', 255)->nullable();
            $table->boolean('is_home')->default(0);
            $table->boolean('is_alias')->default(0);
            $table->boolean('display_in_menu')->default(0);
            $table->boolean('is_protected')->default(0);
            $table->string('allowed_groups', 100)->nullable();
            $table->string('program_type', 100)->default('any')->nullable();
            $table->string('template', 255)->default('default');
            $table->unsignedInteger('position')->nullable();
            $table->enum('status', ['active', 'inactive']);
            $table->timestamps();
            $table->timestamp('published_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists($this->pageTable);
    }
}
