@extends('Core::layouts.cms')

@section('page_heading', 'Media')
@section('page_breadcrumb', 'Media')

@section('page_content')
    <div class="row">
        <div class="col-sm-12">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    @can('core.cms.pages.browse')
                    <li><a href="{{ route('admin.pages.index') }}">Pages</a></li>
                    @endcan
                    @can('core.cms.blocks.browse')
                        <li><a href="{{ route('admin.blocks.index') }}">Blocks</a></li>
                    @endcan
                    @can('core.cms.media.browse')
                    <li class="active"><a href="{{ route('admin.media.index') }}">Media</a></li>
                    @endcan
                </ul>
                <div class="tab-content no-padding">
                    @include('Core::admin.cms.partials.list.files')
                    @include('Core::admin.cms.partials.form.media-uploads')
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script type="text/javascript">
        window.Laravel = window.Laravel || {};
        window.Laravel.csrfToken = "{{ csrf_token() }}";
    </script>
    <script src="/vendor/ignite/js/cms/media-upload.js"></script>
    <script src="/vendor/ignite/js/cms/media-manager.js"></script>
@endsection
