<?php

namespace Ignite\Core\Models\Transformers;

use Ignite\Core\Entities\Transaction;
use Ignite\Core\Entities\User;
use Ignite\Core\Entities\TransactionResource;

class TransactionResourceTransformer
{
    /**
     * Transform the resource into a transaction.
     *
     * @param TransactionResource $resource
     * @param User $user
     *
     * @return Transaction
     */
    public function transform(TransactionResource $resource, User $user)
    {
        return new Transaction([
            'user_id' => $user->getKey(),
            'related_id' => $resource->related_id ?? 0,
            'related_type' => $resource->related_type ?? null,
            'related_name' => $resource->related_name ?? null,
            'type' => $resource->type,
            'description' => $resource->description,
            'notes' => $resource->notes,
            'value' => $resource->value,
            'tax_date' => $resource->tax_date,
            'transaction_date' => $resource->transaction_date,
            'hash' => $resource->hash,
            'created_at' => $resource->created_at,
            'updated_at' => $resource->updated_at,
        ]);
    }
}
