<?php

namespace Ignite\Core\Models\Grid;

use Illuminate\Database\DatabaseManager;
use Ignite\Core\Contracts\Repositories\BlockRepository;
use Yajra\DataTables\DataTables;

class BlockTable extends EloquentTable
{
    /** @var DataTables */
    protected $datatables;

    /** @var BlockRepository */
    protected $blockRepository;

    /** @var BlockFormatter */
    protected $formatter;

    /**
     * BlockTable constructor.
     *
     * @param DataTables $datatables
     * @param DatabaseManager $databaseManager
     * @param array $params
     * @param BlockRepository $repository
     * @param BlockFormatter $formatter
     */
    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        BlockRepository $repository,
        BlockFormatter $formatter,
        array $params = []
    ) {
        parent::__construct($datatables, $databaseManager, $params);
        $this->blockRepository = $repository;
        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'checkbox' => [
                'defaultContent' => '',
                'title'          => '',
                'data'           => 'checkbox',
                'name'           => 'checkbox',
                'orderable'      => false,
                'searchable'     => false,
                'exportable'     => false,
                'printable'      => false,
                'width'          => '10px',
            ],
            'actions' => [
                'title' => 'Actions',
                'name' => 'actions',
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
            ],
            'id' => [
                'title' => 'ID',
                'name' => 'id',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'name' => [
                'title' => 'Name',
                'name' => 'name',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'code' => [
                'title' => 'Code',
                'name' => 'code',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'status' => [
                'title' => 'Status',
                'name' => 'status',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'created_at' => [
                'title' => 'Created Date',
                'name' => 'created_at',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'published_at' => [
                'title' => 'Publish Date',
                'name' => 'published_at',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ]
        ];
    }

    /**
     * The table query.
     *
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Query\Builder|\Illuminate\Support\Collection
     */
    public function query()
    {
        return $this->blockRepository->findRaw();
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        return parent::getBuilderParameters([
            "order" => [2, 'asc'], // Last login at
        ], $this->getCheckboxColumnParameters());
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'checkbox' => [$this->formatter, 'checkbox'],
            'actions' => [$this->formatter, 'actions'],
            'status' => [$this->formatter, 'status'],
            'created_at' => [$this->formatter, 'createdAt'],
            'published_at' => [$this->formatter, 'publishedAt'],
        ];
    }
}
