@extends('Core::layouts.cms')

@php
$templateCode = str_replace('/', '.', ltrim($page->code, '/'))
@endphp

@section('page_heading', 'Editing Page: ' . $page->getLabel())
@section('page_breadcrumb', 'Editing Page: ' . $page->getLabel())

@section('page_content')
    @include('Core::admin.cms.partials.form.page', [
        'url' => route('admin.pages.update', ['id' => $page->getKey()]),
        'page' => $page,
        'method' => 'PUT'
    ])

    @include('Core::admin.cms.partials.form.media-uploads', compact('templateCode'))
    @include('Core::admin.cms.partials.form.media-modal', compact('templateCode'))
@endsection

@section('js')
    @parent
    <script type="text/javascript">
        window.Laravel = window.Laravel || {};
        window.Laravel.csrfToken = "{{ csrf_token() }}";
        window.Laravel.isEditor = true;
    </script>
    <script src="/vendor/ignite/js/cms/media-upload.js"></script>
    <script src="/vendor/ignite/js/cms/media-manager.js"></script>
    <script type="text/javascript">
        window.Pages = {};
        window.Pages.code = $('#form-content-url').val() || '{{ $templateCode }}';
        window.Pages.indexUrl = "{{ route('admin.pages.index') }}";
        window.Pages.createUrl = "{{ route('admin.pages.create') }}";
        window.Pages.editUrl = "{{ route('admin.pages.edit', ['id' => $page->getKey()]) }}";

        jQuery(document).ready(function($) {
            $('#page-editor').igniteEditor({
                csrfToken: window.Laravel.csrfToken,
                templateCode: window.Pages.code
            });
        });
    </script>
@endsection
