<?php

namespace Ignite\Core\Tests\Helpers;

use Carbon\Carbon;
use Ignite\Core\Entities\Import;
use Ignite\Core\Services\Importers\Transactions;
use Illuminate\Support\Facades\Storage;

trait TransactionHelper
{
    /**
     * Create a timestamped file with the given contents.
     *
     * @param $filename
     * @param $extension
     * @param Carbon $date
     * @param $contents
     *
     * @return string
     */
    protected function createdTimestampedFile($filename, $extension, Carbon $date, $contents)
    {
        $file = $filename . $date->format('YmdHis') . '.' . $extension;

        Storage::disk('local')->put($file, $contents);

        return $file;
    }

    /**
     * Set up the import.
     *
     * @param string $contents
     * @param string $label
     *
     * @return Import
     */
    protected function setupImport($contents, $label = 'Transaction')
    {
        $service = Transactions::class;

        $this->app['config']->set('core.import.types.transaction', [
            'label' => 'Transaction',
            'class' => $service
        ]);

        Storage::fake('local');

        $knownDate = Carbon::create(2018, 3, 13, 12);
        Carbon::setTestNow($knownDate);

        $file = $this->createdTimestampedFile('imports/transaction-', 'csv', $knownDate, $contents);
        $log = $this->createdTimestampedFile('imports/transaction-', 'log', $knownDate, "");

        return Import::create([
            'type' => $service,
            'label' => $label,
            'disk' => 'local',
            'file' => $file,
            'log' => $log,
        ]);
    }
}
