<?php

namespace Ignite\Core\Providers;

use Ignite\Core\Events\EnrollmentComplete;
use Ignite\Core\Listeners\AssignUserToGroup;
use Ignite\Core\Listeners\AttachWaitingTransactions;
use Ignite\Core\Listeners\CompleteEnrollment;
use Ignite\Core\Listeners\ScaffoldTheme;
use Ignite\Core\Listeners\SendWelcomeEmail;
use Ignite\Core\Listeners\StopIfImpersonating;
use Ignite\Core\Listeners\StoreLogin;
use Illuminate\Auth\Events\Login;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Auth\Events\Registered;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use SocialiteProviders\Manager\SocialiteWasCalled;
use SocialiteProviders\SalesForce\SalesForceExtendSocialite;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        'ignite.theme.scaffolded' => [
            ScaffoldTheme::class,
        ],
        SocialiteWasCalled::class => [
            SalesForceExtendSocialite::class
        ],
        Login::class => [
            StopIfImpersonating::class,
            StoreLogin::class,
        ],
        Registered::class => [
            AssignUserToGroup::class,
            SendWelcomeEmail::class,
        ],
        PasswordReset::class => [
            CompleteEnrollment::class,
        ],
        EnrollmentComplete::class => [
            AttachWaitingTransactions::class
        ]
    ];

    /**
     * The subscriber classes to register.
     *
     * @var array
     */
    protected $subscribe = [];
}
