<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Entities\Block;

class BlockFormatter extends Formatter
{
    /**
     * Format a checkbox for selecting entries in the grid.
     *
     * @param  object $model
     * @return \Illuminate\Support\HtmlString
     */
    public function checkbox($model)
    {
        return $this->formatCheckbox($model->getKey());
    }

    /**
     * Format the actions column.
     *
     * @param  Block $model
     * @return \Illuminate\Support\HtmlString
     */
    public function actions($model)
    {
        return $this->html($this->buttons([
            [
                'link'  => route('admin.blocks.edit', $model),
                'label' => 'Edit',
                'class' => '',
                'text' => '',
                'type'  => 'default',
                'icon' => 'eye-open',
                'click' => '',
            ], [
                'link'  => route('admin.blocks.destroy', $model),
                'label' => 'Delete',
                'class' => 'delete-entry',
                'text' => 'text-danger',
                'type'  => 'default',
                'icon' => 'trash',
                'click' => "This action will permanently delete the block. Are you sure you want to continue?",
            ]
        ]));
    }

    /**
     * Format the status column.
     *
     * @param  Block $model
     * @return \Illuminate\Support\HtmlString
     */
    public function status($model)
    {
        return $this->html(
            sprintf(
                '<span class="fa fa-circle %s"></span> %s',
                $model->isActive() ? 'text-green' : 'text-red',
                ucfirst($model->status)
            )
        );
    }

    /**
     * Format the published at column.
     *
     * @param  Block $block
     * @return \Illuminate\Support\HtmlString
     */
    public function publishedAt(Block $block)
    {
        return $this->formatDate($block, 'published_at', 'm/d/Y');
    }
}
