<?php

namespace Ignite\Core\Http\ViewComposers;

use Illuminate\Contracts\View\View;
use Ignite\Core\Contracts\Repositories\ImportRepository;

class ImportForm
{
    /**
     * @var ImportRepository
     */
    private $importRepository;

    /**
     * ImportForm constructor.
     *
     * @param ImportRepository $importRepository
     */
    public function __construct(ImportRepository $importRepository)
    {
        $this->importRepository = $importRepository;
    }

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $view->with('allowedTypes', $this->importRepository->getAllowedTypes());
    }
}
