@extends('Core::layouts.master')

@section('body_class', 'sidebar-mini skin-black')

@section('body')
    <div class="wrapper">
        <header class="main-header">
            <a href="{{ url('home') }}" class="logo">
                <span class="logo-mini"><span class="fa fa-rocket"></span></span>
                <span class="logo-lg"><span style="color: #fff; margin-left: 5px; margin-right: 10px" class="fa fa-rocket"></span> <strong>Ignite</strong> Admin</span>
            </a>
            <nav class="navbar navbar-static-top" role="navigation">
                <a href="#" class="sidebar-toggle hidden-sm hidden-md hidden-lg hidden-xl" data-toggle="push-menu" role="button">
                    <span class="sr-only">{{ trans('adminlte::adminlte.toggle_navigation') }}</span>
                </a>
                <div class="navbar-header pull-left">
                    <a href="/" class="navbar-brand">
                        <span class="fa fa-globe text-dark"></span> {{ config('app.name') }}
                        <span class="badge badge-light navbar-badge hidden-xs">View Website</span>
                    </a>
                </div>
                <div class="navbar-custom-menu">
                    <ul class="nav navbar-nav">
                        @php
                        $canAccessParticipantEdit = auth()->user()->can('core.user.edit', auth()->user());
                        $userProfile = $canAccessParticipantEdit
                            ? route('admin.participant.edit', auth()->user()->getKey())
                            : url('/participant/edit');
                        @endphp
                        <li class="dropdown user user-menu">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="true">
                                <img src="https://ui-avatars.com/api/?background=0D8ABC&color=ffffff&name={{ urlencode(auth()->user()->fullName()) }}" class="user-image" alt="{{ auth()->user()->fullName() }}">
                                <span class="hidden-xs">{{ auth()->user()->fullName() }}</span>
                            </a>
                            <ul class="dropdown-menu">
                                <li class="user-header">
                                    <img src="https://ui-avatars.com/api/?background=0D8ABC&color=ffffff&name={{ urlencode(auth()->user()->fullName()) }}" class="img-circle" alt="{{ auth()->user()->fullName() }}">
                                    <p>
                                        {{ auth()->user()->fullName() }}
                                        <small>{{ auth()->user()->groups->sortBy('level')->first()->name }} &middot; Created {{ auth()->user()->created_at->format('jS M, Y') }}</small>
                                    </p>
                                </li>
                                <li class="user-footer">
                                    <div class="pull-left">
                                        <a href="{{ $userProfile }}" class="btn btn-default btn-flat">
                                            <i class="fa fa-fw fa-user-o"></i> Profile
                                        </a>
                                    </div>
                                    <div class="pull-right">
                                        <a href="{{ route('admin.session.destroy') }}" class="btn btn-default btn-flat">
                                            <i class="fa fa-fw fa-power-off"></i> Logout
                                        </a>
                                    </div>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <a href="#" data-toggle="control-sidebar" data-slide="true"><i class="fa fa-cog"></i></a>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <aside class="main-sidebar">
            <section class="sidebar">
                {{ $menu }}
            </section>
        </aside>

        <div class="content-wrapper">
            <section class="content-header">
                @yield('content_header')
            </section>
            <section class="content">
                @yield('content')
            </section>
        </div>
        <footer class="main-footer" style="overflow:hidden; position:relative;">
            <div class="text-left">
                <strong>&copy; {{ date('Y') }} All Rights Reserved.</strong>
                <span> v{{ Program::version() }}</span>
            </div>
            <div class="brightspot" style="position:absolute; top:-120px; right:-50px;">
                <img src="/vendor/ignite/images/brightspot-logo.png" alt="Brightspot" class="img-responsive center-block">
            </div>
        </footer>

        @include('Core::partials.sidebar')
    </div>
@stop
