<?php

namespace Ignite\Core\Traits;

use Illuminate\Support\Str;

trait AttributeToggle
{
    /**
     * An array of attribute names which can be toggled.
     * @var array
     */
    //protected $toggleable = [];

    /**
     * Toggle an attribute.
     *
     * @param  string $name
     * @param  mixed  $value
     * @return mixed
     * @throws \Exception
     */
    public function toggleAttribute($name, $value)
    {
        $method = sprintf('toggle%s', Str::camel($name));

        if (! method_exists($this, $method) && in_array($name, $this->toggleable)) {
            throw new \Exception(sprintf('%s does not exist on %s', $method, __CLASS__));
        }

        return $this->$method($value);
    }
}
