<?php

namespace Ignite\Core\Models\Grid;

class GroupFormatter extends Formatter
{
    /**
     * Custom column for checkboxes.
     *
     * @param \Ignite\Core\Entities\Group $model
     * @return \Illuminate\Support\HtmlString
     */
    public function checkbox($model)
    {
        return $this->formatCheckbox($model->id);
    }
    /**
     * Custom column for actions.
     *
     * @param  \Ignite\Core\Entities\Group $model
     * @return \Illuminate\Support\HtmlString
     */
    public function actions($model)
    {
        $actions = [];

        if (auth()->user()->can('core.security.groups.update')) {
            $actions[] = [
                'link' => route('admin.security.groups.edit', $model->id),
                'label' => 'Edit',
                'icon' => 'pencil'
            ];
        }

        if (auth()->user()->can('core.security.groups.delete') && $model->isUserDefined()) {
            $actions[] = [
                'link' => route('admin.security.groups.destroy', ['group' => $model->id]),
                'label' => 'Delete',
                'class' => 'delete-entry',
                'text' => 'text-danger',
                'type'  => 'default',
                'icon' => 'trash',
                'click' => "This action will permanently delete the group. Are you sure you want to continue?",
            ];
        }

        return $this->html($this->buttons($actions));
    }

    /**
     * Format the column to determine whether the group is active or inactive.
     *
     * @param  \Ignite\Core\Entities\Group $model
     * @return \Illuminate\Support\HtmlString
     */
    public function status($model)
    {
        return $this->html($model->status === 1 ? 'Active' : 'Inactive');
    }

    /**
     * Format the column to determine whether the group is user-defined.
     *
     * @param  \Ignite\Core\Entities\Group $model
     * @return \Illuminate\Support\HtmlString
     */
    public function isUserDefined($model)
    {
        return $this->html($this->formatYesNo($model->is_user_defined));
    }
}
