<section class="chart-metric chart-table {{ $size }}">
    <div id="{{ $element }}" class="metric-panel metric-style-{{ $color ?? 'default' }}">
        <div class="metric-body">
            <p class="metric-label">{{ $label }}</p>
            <div class="metric-graph-full" style="padding-top: 20px; position: relative; min-height: 420px; display: flex; align-items: start; justify-content: center">
                @if (isset($data) && $data->isNotEmpty())
                    <ul class="products-list product-list-in-box" style="width: 100%">
                        @foreach ($data as $item)
                            <li class="item">
                                @if (isset($item->image) && $item->image)
                                    @if (\Illuminate\Support\Str::startsWith($item->image, 'http'))
                                        <div class="product-img">
                                            <img src="{{ $item->image }}" style="width: 50px; height: 32px;" width="50" alt="{{ $item->name }}">
                                        </div>
                                    @else
                                    @foreach (['s3', 'ignite3'] as $disk)
                                        @if (Storage::disk($disk)->has($item->image))
                                            <div class="product-img">
                                                <img src="{{ Storage::disk($disk)->url($item->image) }}" style="width: 50px; height: 32px;" width="50" alt="{{ $item->name }}">
                                            </div>
                                            @break
                                        @endif
                                    @endforeach
                                    @endif
                                @endif
                                @if (isset($item->name) && $item->name)
                                <div style="margin-left: 70px">
                                    <span class="metric-table-count pull-right">{{ $item->total }}</span>
                                    <div class="metric-table-title">
                                        {{ $item->name }}
                                        @if (isset($item->subtitle))
                                            <div style="display: block;" class="metric-table-subtitle">{{ $item->subtitle }}</div>
                                        @endif
                                    </div>
                                </div>
                                @endif
                                @if (! empty($keys))
                                    @foreach ($keys as $key)
                                        {{ $item->$key }}
                                    @endforeach
                                @endif
                            </li>
                        @endforeach
                    </ul>
                @else
                    <div class="text-muted text-center">
                        <span class="fa fa-exclamation-triangle fa-3x text-gray" style="margin-bottom: 20px"></span>
                        <h3 class="metric-label">No data available</h3>
                        <p class="metric-change">Try choosing a different date range</p>
                    </div>
                @endif
            </div>
        </div>
        @if (! empty($help))
            <button type="button" class="metric-help" data-toggle="tooltip" data-placement="left" title="{{ $help ?? '' }}" data-trigger="hover">
                <span class="fa fa-question metric-icon-bg text-gray"></span>
            </button>
        @endif
    </div>
</section>
