<section class="chart-metric chart-line {{ $size }}">
    <div id="{{ $element }}" class="metric-panel metric-style-{{ $color ?? 'default' }}">
        <div class="metric-body">
            <p class="metric-label">{{ $label }}</p>
            <div class="metric-graph-full" style="position: relative; min-height: 320px; display: flex; align-items: center; justify-content: center">
                @if (! isset($data) || empty($data))
                    <div class="text-muted text-center">
                        <span class="fa fa-exclamation-triangle fa-3x text-gray" style="margin-bottom: 20px"></span>
                        <h3 class="metric-label">No data available</h3>
                        <p class="metric-change">Try choosing a different date range</p>
                    </div>
                @else
                    <div class="chart" id="{{ $element }}-graph"></div>
                @endif
            </div>
        </div>
        @if (! empty($help))
            <button type="button" class="metric-help" data-toggle="tooltip" data-placement="left" title="{{ $help ?? '' }}" data-trigger="hover">
                <span class="fa fa-question metric-icon-bg text-gray"></span>
            </button>
        @endif
    </div>
</section>
@push('js')
    @if (isset($data) && ! empty($data))
    <script type="text/javascript">
        var options = {
            series: {!! json_encode($data) !!},
            colors: {!! json_encode($colors) !!},
            chart: {
                height: {!! $height !!},
                zoom: {enabled: false},
                toolbar: {show: false},
            },
            dataLabels: {enabled: false},
            stroke: {
                width: {!! json_encode($strokeWidth) !!},
                curve: "{{ $strokeCurve }}",
                dashArray: {!! json_encode($strokeDash) !!}
            },
            legend: {
                position: 'bottom',
                fontSize: '13px',
                fontFamily: '"Source Sans Pro", Helvetica, Arial, sans-serif',
                fontWeight: 400,
                labels: {
                    colors: '#1a202c'
                },
                offsetY: 12,
                itemMargin: {
                    horizontal: 5,
                    vertical: 5
                }
            },
            markers: {
                size: 4,
                hover: {
                    sizeOffset: 4
                }
            },
            xaxis: {
                type: 'categories',
                labels: {
                    show: true,
                    style: {
                        colors: '#a0aec0',
                        fontSize: '14px',
                        fontFamily: '"Source Sans Pro", Helvetica, Arial, sans-serif',
                        fontWeight: 400,
                        cssClass: 'apexcharts-yaxis-label',
                    }
                },
                showFirstLabel: true,
            },
            yaxis: {
                showFirstLabel: false,
                labels: {
                    show: true,
                    style: {
                        colors: '#a0aec0',
                        fontSize: '12px',
                        fontFamily: '"Source Sans Pro", Helvetica, Arial, sans-serif',
                        fontWeight: 400,
                        cssClass: 'apexcharts-yaxis-label',
                    }
                },
            },
            grid: {
                borderColor: '#f1f1f1',
            },
            tooltip: {
                enabled: true,
                enabledOnSeries: false,
                shared: true,
                followCursor: false,
                fixed: {
                    enabled: true,
                    position: 'topRight',
                    offsetX: 0,
                    offsetY: 0,
                },
                onDatasetHover: {
                    highlightDataSeries: true
                }
            }
        };

        var chart = new ApexCharts(document.querySelector("#{{ $element }}-graph"), options);
        chart.render();
    </script>
    @endif
@endpush
