<?php

return [
    'name' => 'Core',

    'use_email_as_username' => true,

    'google' => [
        'analytics' => [
            'code' => env('GOOGLE_ANALYTICS_CODE', ''),
            'key_file' => env('GOOGLE_KEY_FILE', __DIR__ . '/../Resources/services/ignite-platform-3-4fcc58082a35.json')
        ]
    ],

    // The program type determines the content and features displayed to the
    // participant on certain pages. Currently, the recognized/understood
    // types are: redemption, payout. Otherwise default to redemption.
    'program_type' => 'redemption',

    'locale' => [
        'money' => 'en_US.UTF-8'
    ],

    // TODO: Remove all of this
    'groups' => [
        'it_is_all_groups' => true, // TODO: Remove this
        'it' => 1,                  // TODO: Rename group to 'Super Admin'
        'site_admin' => 2,          // TODO: Rename group to 'Manager'
        'program_admin' => 3,       // TODO: Rename group to 'Specialist'
        'client_admin' => 4,        // TODO: Rename group to 'Client'
        'participant' => 8,         // TODO: Rename group to 'Participant'
        'authenticated' => 9,       // TODO: Remove this group
        'guest' => 10,              // TODO: Remove this group
    ],

    'auth' => [
        'drivers' => [
            env('APP_AUTH_SSO_DEFAULT', null)
        ]
    ],

    // Ignite 3 Core supports older website users from Ignite 2 via a user
    // provider fallback mechanism in Laravel. In the case of Ignite 2,
    // we need both the static application salt and the user salt.
    'password' => [
        'salt' => env('APP_PASSWORD_SALT', ''),
    ],

    // Ignite 3 Core supports "demo mode" where the system will generate some
    // sample demoable data for participants, claims and catalog. The next
    // step is to move the code from Core to a dedicated Demo module.
    'demo' => [
        'allow_events_in_console' => false
    ],

    // The Ignite 3 admin account is added during the seeding process via the
    // command line. In order to dynamically change the admin credentials
    // at install time, you can set the following via environment vars.
    'admin' => [
        'email' => env('ADMIN_EMAIL', 'it@brightspot.email'),
        'password' => env('ADMIN_PASSWORD', 'br1ght3r1d34s!')
    ],

    // At certain points in the Ignite 3 Core, HTML is saved to the database,
    // in order to protect our sites from XSS attacks we purify the html
    // before storing it, so we are safe to render it to the template.
    'html' => [
        // HTML Purifier Options - http://htmlpurifier.org/live/configdoc/plain.html
        'options' => [
            'Core.Encoding' => 'UTF-8',
            'HTML.Doctype' => 'XHTML 1.0 Strict',
            'HTML.Allowed' => 'h1[class],h2[class],h3[class],h4[class],h5[class],h6[class],div[class|style],blockquote[class],ul[class|style],ol[class|style],li[class],p[style|class],b[class|style],strong[class|style],i[class|style],em[class|style],a[class|style|href|title],br[class|style],span[class|style],img[class|style|width|height|alt|src],table[class|style|summary],hr[class|style],tbody[class|style],thead[class|style],td[class|style|abbr],tr[class|style],th[class|style|abbr],tfoot',
            'CSS.AllowedProperties' => 'font-size,font-weight,font-style,text-align,text-decoration,padding,margin,color,background-color,text-align,max-width,max-height,height,width',
            'AutoFormat.AutoParagraph' => true,
            'AutoFormat.RemoveEmpty' => true
        ]
    ],

    //
    'participant' => [
        'types' => [
            'Account Executive' => 'Account Executive',
            'Sales Engineer' => 'Sales Engineer',
            'Sales Manager' => 'Sales Manager',
            'Sales Engineer Manager' => 'Sales Engineer Manager',
        ],

        'emails' => [
            'enrollment' => [
                'active' => true,
                'template' => 'emails.auth.registered',
                'subject' => 'Activate your Registration - Enrollment Confirmation'
            ]
        ],
    ],

    'dashboard' => [
        'default' => 'Core',
        'autolocate' => true,
        'startCurrent' => now()->startOfMonth()->format('Y-m-d'),
        'endCurrent' => now()->endOfMonth()->format('Y-m-d'),
        'startPrevious' => now()->subMonth()->startOfMonth()->format('Y-m-d'),
        'endPrevious' => now()->subMonth()->endOfMonth()->format('Y-m-d'),
    ],

    'cms' => [
        'disk' => env('CMS_STORAGE_DISK', 'public'),
        'templates' => [
            'default' => 'Default',
        ],
    ],

    'transaction' => [
        'resource' => [
            'identifier' => 'email',
            'resolvers' => [
                'user' => Ignite\Core\Models\Import\Resolvers\UserResolver::class
            ]
        ]
    ],

    'report' => [
        'filters' => [
            \Ignite\Core\Models\Report\EnrollmentReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => \Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'participant.created_at',
                    'label' => 'Sign Up Date',
                ],
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => \Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'participant.approved_at',
                    'label' => 'Enroll Date',
                ],
                [
                    'view' => 'Core::admin.report.filters.country',
                    'scope' => \Ignite\Core\Models\Grid\Scopes\CountryScope::class,
                    'request' => ['field', 'value'],
                    'label' => 'Country',
                    'field' => 'participant.country',
                    'options' => ['US' => 'US', 'CA' => 'Canada']
                ]
            ],
            \Ignite\Core\Models\Report\TaxReport::class => [
                [
                    [
                        'view' => 'Core::admin.report.filters.daterange',
                        'scope' => \Ignite\Core\Models\Grid\Scopes\DateScope::class,
                        'request' => ['field', 'value', 'startDate', 'endDate'],
                        'field' => 'transaction.transaction_date',
                        'label' => 'Transaction Date'
                    ],
                    [
                        'view' => 'Core::admin.report.filters.daterange',
                        'scope' => \Ignite\Core\Models\Grid\Scopes\DateScope::class,
                        'request' => ['field', 'value', 'startDate', 'endDate'],
                        'field' => 'transaction.transaction_date',
                        'label' => 'Transaction Date',
                    ],
                    [
                        'view' => 'Core::admin.report.filters.country',
                        'scope' => \Ignite\Core\Models\Grid\Scopes\CountryScope::class,
                        'request' => ['field', 'value'],
                        'field' => 'participant.country',
                        'label' => 'Country',
                        'options' => ['US' => 'US', 'CA' => 'Canada']
                    ]
                ]
            ],
            \Ignite\Core\Models\Report\TotalEarnedReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => \Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'transaction.transaction_date',
                    'label' => 'Transaction Date'
                ],
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => \Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'participant.created_at',
                    'label' => 'Enrolled Date'
                ],
                [
                    'view' => 'Core::admin.report.filters.country',
                    'scope' => \Ignite\Core\Models\Grid\Scopes\CountryScope::class,
                    'request' => ['field', 'value'],
                    'field' => 'participant.country',
                    'label' => 'Country',
                    'options' => ['US' => 'US', 'CA' => 'Canada']
                ]
            ],
            \Ignite\Core\Models\Report\TotalRedeemedReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => \Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'transaction.transaction_date',
                    'label' => 'Transaction Date'
                ],
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => \Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'participant.created_at',
                    'label' => 'Enrolled Date',
                ],
                [
                    'view' => 'Core::admin.report.filters.country',
                    'scope' => \Ignite\Core\Models\Grid\Scopes\CountryScope::class,
                    'request' => ['field', 'value'],
                    'field' => 'participant.country',
                    'label' => 'Country',
                    'options' => ['US' => 'US', 'CA' => 'Canada']
                ]
            ],
            \Ignite\Core\Models\Report\TotalBalanceReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => \Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'transaction.transaction_date',
                    'label' => 'Transaction Date'
                ],
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => \Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'participant.created_at',
                    'label' => 'Enrolled Date',
                ],
                [
                    'view' => 'Core::admin.report.filters.country',
                    'scope' => \Ignite\Core\Models\Grid\Scopes\CountryScope::class,
                    'request' => ['field', 'value'],
                    'field' => 'participant.country',
                    'label' => 'Country',
                    'options' => ['US' => 'US', 'CA' => 'Canada']
                ]
            ]
        ]
    ],

    'import' => [
        'queue' => true,
        'timeout' => 300,
        'ui' => [
            'recent' => [
                'per_page' => 10
            ]
        ],
        'reader' => [
            'pattern' => '/\[(?P<date>.*)\] (?P<logger>\w+).(?P<level>\w+): (?P<message>[^\[\{]+) (?P<context>[\[\{].*[\]\}]) (?P<extra>[\[\{].*[\]\}])/',
        ],
        'types' => [
            'participant' => [
                'class' => '\Ignite\Core\Services\Importers\Participants',
                'label' => 'Participants'
            ],
            'transaction' => [
                'class' => '\Ignite\Core\Services\Importers\Transactions',
                'label' => 'Transaction'
            ],
        ],
    ],
];
