<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Facades\Format;

class TransactionFormatter extends Formatter
{
    /**
     * The balance of transactions for the user.
     *
     * @param object $model
     * @return string
     */
    public function balance($model)
    {
        return $this->html(Format::balance($model->value));
    }

    public function idWithLinkToUser($model)
    {
        return $model->user_id;
    }

    public function emailWithLinkToUser($model)
    {
        return $model->email;
    }
}
