<?php

namespace Ignite\Core\Http\Controllers\Admin;

use Exception;
use Ignite\Core\Models\Grid\AbstractTable;
use Ignite\Flash\Facades\Flash;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Ignite\Core\Entities\Report;
use Ignite\Core\Models\Grid\ReportTable;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Mail;
use Nwidart\Modules\Facades\Module;

class ReportController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @param  ReportTable $table
     * @param  Request     $request
     * @return \Illuminate\Http\JsonResponse|\Illuminate\View\View
     */
    public function index(ReportTable $table, Request $request)
    {
        if ($request->wantsJson()) {
            return $table->ajax();
        }

        return $table->render('Core::admin.report.index');
    }

    /**
     * Show the specified resource.
     *
     * @param  int $id
     *
     * @return RedirectResponse
     */
    public function show($id, Request $request)
    {
        /** @var Report $report */
        $report = Report::find((int) $id);

        if ($report->isUnpublished() || $report->isSensitive()) {
            Flash::error(sprintf(
                "The requested report `%s` is not available. Please contact I.T to request access.",
                $report->getName()
            ));
            return redirect()->route('admin.reports.index');
        }

        /** @var AbstractTable $table */
        $table = $report->getReportClassInstance();

        $filters = config('core.report.filters', []);
        $configs = collect(Module::getOrdered())->except('Core');

        foreach ($configs as $module) {
            $filters = array_merge_recursive($filters, config("{$module->getLowerName()}.report.filters", []));
        }

        foreach ($filters as $class => $filter) {
            if (get_class($table) === $class) {
                if (isset($filter['scope']) && isset($filter['request']) && $request->has($filter['request'])) {
                    $table->addScope(app($filter['scope'], $request->only($filter['request'])));
                }
            }
        }

        if ($request->wantsJson()) {
            return $table->ajax();
        }

        return $table->render('Core::admin.report.show', compact('report', 'filters'));
    }

    /**
     * Send the report.
     *
     * @todo   Move to SecureReportController@store
     * @param  int $id
     *
     * @return RedirectResponse
     * @throws Exception
     */
    public function send($id)
    {
        /** @var Report $report */
        $report = Report::find((int) $id);

        if (! $report->isSensitive()) {
            Flash::error(
                "The requested report `{$report->getName()}` does not contain sensitive information, " .
                "you are free to view via the web interface."
            );
            return redirect()->route('admin.reports.show', $report);
        }

        /** @var AbstractTable $table */
        $table = $report->getReportClassInstance();

        $table->storeAsExcel($filepath = $report->getFilename('reports'));

        //return new TaxReport($filepath);
        // TODO: Implement the logic to send the sensitive file to Box.com via their API.
    }
}
