@extends('Participant::layouts.master')

@section('page_heading', 'Balance Adjustment')
@section('page_breadcrumb', 'Balance Adjustments')

@section('page_content')
    <div class="row">
        <div class="form-horizontal col-sm-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h4 class="box-title">
                        Balance Adjustment for {{ $participant['first'] }} {{ $participant['last'] }}
                    </h4>
                </div>
                <div class="box-body">
                    @include('Core::admin.transactions.partials.form', ['participant' => $participant])
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script>
        $(document).ready(function(){
            $('.datepicker').datepicker({
                format: 'mm/dd/yyyy',
                autoclose: true
            }).on('show.bs.modal', function(event) {
                event.stopPropagation();
            });

            $('#adjustForm').validate();
        });
    </script>
@endsection
