<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Entities\Import;
use Illuminate\Database\DatabaseManager;
use Illuminate\Support\Arr;
use Yajra\DataTables\DataTables;

class ImportTable extends EloquentTable
{
    /** @var DataTables */
    protected $datatables;

    /** @var ReportFormatter */
    protected $formatter;

    /**
     * ImportTable constructor.
     *
     * @param DataTables $datatables
     * @param DatabaseManager $databaseManager
     * @param array $params
     * @param ImportFormatter $formatter
     */
    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        array $params = [],
        ImportFormatter $formatter
    ) {
        parent::__construct($datatables, $databaseManager, $params);
        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'action' => [
                'title' => 'Actions',
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'width' => '90px',
            ],
            'status' => [
                'title' => 'Status',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
                'width' => '75px',
            ],
            'created_at' => [
                'title' => 'Created At',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'created_by' => [
                'title' => 'Created By',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'type' => [
                'title' => 'Type',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'file' => [
                'title' => 'File',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'records' => [
                'title' => 'Records',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'run_at' => [
                'title' => 'Run At',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'run_by' => [
                'title' => 'Run By',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
        ];
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'action' => [$this->formatter, 'actions'],
            'status' => [$this->formatter, 'statusLabel'],
            'type' => [$this->formatter, 'type'],
            'file' => [$this->formatter, 'file'],
            'created_at' => [$this->formatter, 'createdAt'],
            'created_by' => [$this->formatter, 'createdBy'],
            'run_at' => [$this->formatter, 'runAt'],
            'run_by' => [$this->formatter, 'runBy'],
        ];
    }

    /**
     * The table query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query()
    {
        return Import::query();
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        $params = parent::getBuilderParameters();

        return Arr::except(array_merge($params, [
            'order' => [[2, 'desc']],
            'buttons' => [
                'pageLength',
                $this->getColumnVisibilityButton(),
                'csv'
            ],
        ]), ['dom']);
    }
}
