<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Entities\Import;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Services\DataTable;

class ImportTable extends DataTable
{
    /** @var DataTables */
    protected $datatables;

    /** @var ReportFormatter */
    protected $formatter;

    /**
     * BlockTable constructor.
     *
     * @param DataTables      $datatables
     */
    public function __construct(DataTables $datatables)
    {
        $this->datatables = $datatables;
        $this->formatter = new ImportFormatter();
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
            'action' => [
                'title' => 'Actions',
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'width' => '75px',
            ],
            'status' => [
                'title' => 'Status',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
                'width' => '75px',
            ],
            'created_at' => [
                'title' => 'Created At',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'created_by' => [
                'title' => 'Created By',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'type' => [
                'title' => 'Type',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'file' => [
                'title' => 'File',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'records' => [
                'title' => 'Records',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'run_at' => [
                'title' => 'Run At',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'run_by' => [
                'title' => 'Run By',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
        ];
    }

    /**
     * Render the table as HTML.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        $columns = $this->getColumns();

        return $this->builder()->columns($columns);
    }

    /**
     * Get the table data.
     *
     * @return \Yajra\DataTables\DataTableAbstract|\Yajra\DataTables\EloquentDataTable
     */
    public function dataTable()
    {
        $table = $this->datatables->eloquent($this->query());

        $table->addColumn('action', [$this->formatter, 'actions'], 0)
            ->editColumn('status', [$this->formatter, 'statusLabel'])
            ->editColumn('type', [$this->formatter, 'type'])
            ->editColumn('file', [$this->formatter, 'file'])
            ->editColumn('created_at', [$this->formatter, 'createdAt'])
            ->editColumn('created_by', [$this->formatter, 'createdBy'])
            ->editColumn('run_at', [$this->formatter, 'runAt'])
            ->editColumn('run_by', [$this->formatter, 'runBy']);

        return $table;
    }

    /**
     * The table query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query()
    {
        return $this->applyScopes(
            Import::query()
        );
    }
}
