<?php

namespace Ignite\Core\Models\Dashboard\Concerns;

trait DeterminesPercentageChange
{
    /**
     * Determine the percentage difference from the current period to the previous period.
     *
     * (|𝑉1−𝑉2|/[(𝑉1+𝑉2)/2])×100
     *
     * @param int|float $current
     * @param int|float $previous
     *
     * @return string
     */
    public function determinePercentageChange($current, $previous)
    {
        $current = abs($current);
        $previous = abs($previous);

        // You cannot determine percentage change from 0.
        if ($current == 0 || $previous == 0) {
            return 0;
        }

        $value = abs((($current - $previous) / (($current + $previous) / 2) * 100));

        return number_format($value, 1) . '%';
    }

    /**
     * The direction of change in difference for the given values.
     *
     * @param int|float $current
     * @param int|float $previous
     *
     * @return int|false
     */
    public function determineChangeType($current, $previous)
    {
        // You cannot determine percentage change from 0.
        if ($current === 0 || $previous === 0) {
            return false;
        }

        if ($current > $previous) {
            return 1;
        }

        if ($current < $previous) {
            return -1;
        }

        return 0;
    }
}
