@extends('Core::layouts.participant')

@section('page_heading', $pageTitle = 'Participants')
@section('page_breadcrumb', $pageTitle)

@section('tab_menu')
    @include('Core::partials.tabs', [
        'statuses' => $statuses,
        'route' => 'admin.participant.index'
    ])
@endsection

@section('tab_content')
    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            var buttons = [];
            @can('core.user.participant.create')
            buttons.push({
              text: '<span class="fa fa-plus text-success"></span> <span class="text-success">Create</span>',
              action: function (e) {
                e.preventDefault();
                window.location.href = '{{ route('admin.participant.create', ['type' => 'participant']) }}';
              }
            });
            @endcan
            $dataTable.customButtons({
                buttons: buttons
            });
        });
    </script>
@endsection
