<?php

namespace Ignite\Core\Models\Dashboard\Charts;

use Ignite\Core\Contracts\Dashboard\WithInlineSeries;
use Ignite\Core\Contracts\Dashboard\WithPercentageChange;
use Ignite\Core\Models\Dashboard\Concerns\DeterminesPercentageChange;
use Ignite\Core\Services\Google\Analytics\Client;

class PageviewsStat extends BaseGoogleAnalyticsMetric implements WithInlineSeries, WithPercentageChange
{
    use DeterminesPercentageChange;

    /**
     * Create a new stat instance.
     *
     * @param array|object $attributes
     * @param Client $analytics
     */
    public function __construct(Client $analytics, $attributes = [])
    {
        $attributes = array_merge([
            'label' => 'Pageviews',
        ], $attributes);

        parent::__construct($analytics, $attributes);
    }

    /**
     * Set the series data. E.g. [day => total]
     *
     * @param array $data
     */
    public function setSeries(array $data)
    {
        $this->offsetSet('series', array_filter(array_map(function ($value) {
            return ($value == '' || $value == 0) ? null : $value;
        }, $data)));

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setPercentageChange($current, $previous)
    {
        $this->offsetSet('current', $this->decorate($current));
        $this->offsetSet('previous', $this->decorate($previous));
        $this->offsetSet('direction', $this->determineChangeType($current, $previous));
        $this->offsetSet('percentage', $this->determinePercentageChange($current, $previous));
    }

    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement()
    {
        return $this->get('key', 'pageviews-stat');
    }

    /**
     * The chart size in the layout.
     *
     * @return string
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-6 col-sm-3');
    }

    /**
     * Get the correct data value from storage.
     *
     * @return int
     * @throws \Google_Exception
     */
    public function getData()
    {
        return $this->prepareData('pageviews');
    }

    /**
     * @inheritDoc
     */
    protected function decorate($value)
    {
        return number_format($value);
    }
}
