<?php

namespace Ignite\Core\Audit;

use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Contracts\AuditDriver;
use OwenIt\Auditing\Drivers\Database;
use OwenIt\Auditing\Models\Audit as AuditModel;

class UserDriver extends Database implements AuditDriver
{
    /**
     * @inheritDoc
     */
    public function audit(Auditable $model): \OwenIt\Auditing\Contracts\Audit
    {
        $class = config('audit.implementation', AuditModel::class);

        $audit = $model->toAudit();

        return $class::create($audit);
    }
}
