<form class="form-inline pull-right" id="date-range-picker">
    {{--<div class="form-group">
        <select id="date-range-type" name="type" class="form-control select2">
            @foreach ($types as $type => $name)
                <option {{ $type === $selectedType ? 'selected' : '' }} value="{{ $type }}">{{ $name }}</option>
            @endforeach
        </select>
    </div>

    <div class="form-group"><span id="date-range-with"> with </span></div>--}}

    <!-- Current Month -->
    <div style="min-width: 100px" class="form-group {{ $selectedType === 'month' ? '' : 'hidden' }}">
        <select style="min-width: 100px" id="date-range-current-month" name="current_month" class="form-control select2">
            @foreach ($months as $month => $name)
                <option {{ $month === $selectedCurrent->month ? 'selected' : '' }} value="{{ $month }}">{{ $name }}</option>
            @endforeach
        </select>
    </div>

    <!-- Current Quarter -->
    <div class="form-group {{ $selectedType === 'quarter' ? '' : 'hidden' }}">
        <select id="date-range-current-quarter" name="current_quarter" class="form-control select2">
            @foreach ($quarters as $quarter)
                <option {{ $quarter === $selectedCurrent->quarter ? 'selected' : '' }} value="{{ $quarter }}">{{ $quarter }}</option>
            @endforeach
        </select>
    </div>

    <!-- Current Year -->
    <div class="form-group">
        <select id="date-range-current-year" name="current_year" class="form-control select2">
            @foreach ($years as $year)
                <option {{ $year === $selectedCurrent->year ? 'selected' : '' }} value="{{ $year }}">{{ $year }}</option>
            @endforeach
        </select>
    </div>

    <div class="form-group"><span id="date-range-vs"> vs </span></div>

    <!-- Previous Month -->
    <div style="min-width: 100px" class="form-group {{ $selectedType === 'month' ? '' : 'hidden' }}">
        <select id="date-range-previous-month" name="previous_month" class="form-control select2">
            @foreach ($months as $month => $name)
                <option {{ $month === $selectedPrevious->month ? 'selected' : '' }} value="{{ $month }}">{{ $name }}</option>
            @endforeach
        </select>
    </div>

    <!-- Previous Quarter -->
    <div class="form-group {{ $selectedType === 'quarter' ? '' : 'hidden' }}">
        <select id="date-range-previous-quarter" name="current_previous" class="form-control select2">
            @foreach ($quarters as $quarter)
                <option {{ $quarter === $selectedPrevious->quarter ? 'selected' : '' }} value="{{ $quarter }}">{{ $quarter }}</option>
            @endforeach
        </select>
    </div>

    <!-- Previous Year -->
    <div class="form-group">
        <select id="date-range-previous-year" name="previous_year" class="form-control select2">
            @foreach ($years as $year)
                <option {{ $year === $selectedPrevious->year ? 'selected' : '' }} value="{{ $year }}">{{ $year }}</option>
            @endforeach
        </select>
    </div>

    <div class="form-group">
        <button type="submit" class="btn btn-default">Change</button>
    </div>
</form>

@push('js')
    <script>
        jQuery(function ($) {
            var pickerForm = $('#date-range-picker');
            var pickerType = $('#date-range-type');

            pickerType.on('change', function () {
                window.location.href = '/admin?type=' + $(this).val();
            });

            pickerForm.on('submit', function (e) {
                e.preventDefault();
                // get the comparison type
                var selectedType = $(this).find('#date-range-type').val() || 'month';

                // get the current month value
                var currentMonth = $(this).find('#date-range-current-month').val();
                // get the current year value
                var currentYear = $(this).find('#date-range-current-year').val();

                // get the previous month value
                var previousMonth = $(this).find('#date-range-previous-month').val();
                // get the previous year value
                var previousYear = $(this).find('#date-range-previous-year').val();

                // redirect with the correct values
                var currentStart, currentEnd, previousStart, previousEnd;

                if (selectedType === 'month') {
                    currentStart = moment([currentYear, currentMonth -1]).startOf('month').startOf('day');
                    currentEnd = currentStart.clone().endOf('month').endOf('day');
                }

                if (selectedType === 'quarter') {
                    currentStart = moment([currentYear, currentMonth -1]).startOf('quarter').startOf('day');
                    currentEnd = currentStart.clone().endOf('quarter').endOf('day');
                }

                if (selectedType === 'year') {
                    currentStart = moment([currentYear, currentMonth -1]).startOf('year').startOf('day');
                    currentEnd = currentStart.clone().endOf('year').endOf('day');
                }

                if (selectedType === 'month') {
                    previousStart = moment([previousYear, previousMonth - 1]).startOf('month').startOf('day');
                    previousEnd = previousStart.clone().endOf('month').endOf('day');
                }

                if (selectedType === 'quarter') {
                    previousStart = moment([previousYear, previousMonth - 1]).startOf('quarter').startOf('day');
                    previousEnd = previousStart.clone().endOf('quarter').endOf('day');
                }

                if (selectedType === 'year') {
                    previousStart = moment([previousYear, previousMonth - 1]).startOf('year').startOf('day');
                    previousEnd = previousStart.clone().endOf('year').endOf('day');
                }

                window.location.href = '/admin' + '?type=' + selectedType + '&current-start=' + currentStart.format('YYYY-MM-DD') + '&current-end=' + currentEnd.format('YYYY-MM-DD') + '&previous-start=' + previousStart.format('YYYY-MM-DD') + '&previous-end=' + previousEnd.format('YYYY-MM-DD');
            });
        });
    </script>
@endpush
