<?php

namespace Ignite\Core\Contracts\Repositories;

interface ImportRepository
{
    /**
     * Get a pre-configured Import query builder.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query();

    /**
     * Find an import record by ID.
     *
     * @param int $id
     *
     * @return \Ignite\Core\Entities\Import
     */
    public function find($id);

    /**
     * Paginate import records.
     *
     * @param  int $records
     * @return \Illuminate\Contracts\Pagination\LengthAwarePaginator
     */
    public function paginate($records = 10);

    /**
     * Find all active imports.
     *
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function findAll();

    /**
     * Create a new Import record.
     *
     * @param array $data
     *
     * @return \Ignite\Core\Entities\Import
     */
    public function create(array $data);

    /**
     * Delete the import with the provided ID.
     *
     * @param  int $id
     * @return bool
     * @throws \Exception
     */
    public function delete($id);

    /**
     * The allowed types as a map of class => label.
     *
     * @return array
     */
    public function getAllowedTypes();
}
