<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(\Ignite\Core\Entities\Participant::class, function (\Faker\Generator $faker) {
    $user = factory(Ignite\Core\Entities\User::class, 1)->create()->first();

    return [
        "user_id" => $user->user_id,
        "title" => null,
        "email" => $user->email,
        "first" => $user->first,
        "last" => $user->last,
        "type" => "Account Executive",
        "employee_id" => null,
        "phone1" => $faker->phoneNumber,
        "phone2" => null,
        "phone3" => null,
        "department_1" => null,
        "department_2" => null,
        "address_1" => $faker->streetAddress,
        "address_2" => null,
        "city" => $faker->city,
        "state" => $faker->stateAbbr,
        "postal" => $faker->postcode,
        "country" => 'US',
        "work_address_1" => null,
        "work_address_2" => null,
        "work_city" => null,
        "work_state" => null,
        "work_postal" => null,
        "work_country" => null,
        "alternate_email" => null,
        "region" => null,
        "dob" => null,
        "ssn" => null,
        "agree_confirm_1" => null,
        "agree_confirm_2" => null,
        "status" => 1,
        "archived" => 0,
        "idc" => null,
        "internal" => 1,
        "internal_notes" => null,
        "approved_at" => $faker->date('Y-m-d H:i:s'),
        "created_at" => $faker->date('Y-m-d H:i:s'),
        "updated_at" => $faker->date('Y-m-d H:i:s'),
    ];
});
